/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

public final class StandardNames {
    @JvmField
    @NotNull
    public static final Name ENUM_VALUES;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUE_OF;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @JvmField
    @NotNull
    public static final List<String> PREFIXES;
    @JvmField
    @NotNull
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    @NotNull
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;
    @NotNull
    public static final StandardNames INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getFunctionName(int parameterCount) {
        return "Function" + parameterCount;
    }

    @JvmStatic
    @NotNull
    public static final ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final String getSuspendFunctionName(int parameterCount) {
        return FunctionClassKind.SuspendFunction.getClassNamePrefix() + parameterCount;
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        Intrinsics.checkNotNullParameter(arrayFqName, "arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026d(primitiveType.typeName)");
        return fqName2;
    }

    private StandardNames() {
    }

    static {
        StandardNames standardNames;
        INSTANCE = standardNames = new StandardNames();
        Name name = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"values\")");
        ENUM_VALUES = name;
        Name name2 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue(name2, "Name.identifier(\"valueOf\")");
        ENUM_VALUE_OF = name2;
        COROUTINES_PACKAGE_FQ_NAME_RELEASE = new FqName("kotlin.coroutines");
        FqName fqName2 = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("experimental"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"experimental\"))");
        COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL = fqName2;
        FqName fqName3 = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("intrinsics"));
        Intrinsics.checkNotNullExpressionValue(fqName3, "COROUTINES_PACKAGE_FQ_NA\u2026identifier(\"intrinsics\"))");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL = fqName3;
        FqName fqName4 = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue(fqName4, "COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL = fqName4;
        FqName fqName5 = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue(fqName5, "COROUTINES_PACKAGE_FQ_NA\u2026entifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_RELEASE = fqName5;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        PREFIXES = kotlin.collections.CollectionsKt.listOf("KProperty", "KMutableProperty", "KFunction", "KSuspendFunction");
        Name name3 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue(name3, "Name.identifier(\"kotlin\")");
        BUILT_INS_PACKAGE_NAME = name3;
        FqName fqName6 = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
        Intrinsics.checkNotNullExpressionValue(fqName6, "FqName.topLevel(BUILT_INS_PACKAGE_NAME)");
        BUILT_INS_PACKAGE_FQ_NAME = fqName6;
        FqName fqName7 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue(fqName7, "BUILT_INS_PACKAGE_FQ_NAM\u2026identifier(\"annotation\"))");
        ANNOTATION_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue(fqName8, "BUILT_INS_PACKAGE_FQ_NAM\u2026dentifier(\"collections\"))");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName8;
        FqName fqName9 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue(fqName9, "BUILT_INS_PACKAGE_FQ_NAM\u2026ame.identifier(\"ranges\"))");
        RANGES_PACKAGE_FQ_NAME = fqName9;
        FqName fqName10 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue(fqName10, "BUILT_INS_PACKAGE_FQ_NAM\u2026(Name.identifier(\"text\"))");
        TEXT_PACKAGE_FQ_NAME = fqName10;
        FqName[] fqNameArray = new FqName[7];
        fqNameArray[0] = BUILT_INS_PACKAGE_FQ_NAME;
        fqNameArray[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        fqNameArray[2] = RANGES_PACKAGE_FQ_NAME;
        fqNameArray[3] = ANNOTATION_PACKAGE_FQ_NAME;
        fqNameArray[4] = KOTLIN_REFLECT_FQ_NAME;
        FqName fqName11 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue(fqName11, "BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(\"internal\"))");
        fqNameArray[5] = fqName11;
        fqNameArray[6] = COROUTINES_PACKAGE_FQ_NAME_RELEASE;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf(fqNameArray);
    }

    public static final class FqNames {
        @JvmField
        @NotNull
        public static final FqNameUnsafe any;
        @JvmField
        @NotNull
        public static final FqNameUnsafe nothing;
        @JvmField
        @NotNull
        public static final FqNameUnsafe cloneable;
        @JvmField
        @NotNull
        public static final FqName suppress;
        @JvmField
        @NotNull
        public static final FqNameUnsafe unit;
        @JvmField
        @NotNull
        public static final FqNameUnsafe charSequence;
        @JvmField
        @NotNull
        public static final FqNameUnsafe string;
        @JvmField
        @NotNull
        public static final FqNameUnsafe array;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _boolean;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _char;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _byte;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _short;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _int;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _long;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _float;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _double;
        @JvmField
        @NotNull
        public static final FqNameUnsafe number;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _enum;
        @JvmField
        @NotNull
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        @NotNull
        public static final FqName throwable;
        @JvmField
        @NotNull
        public static final FqName comparable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe intRange;
        @JvmField
        @NotNull
        public static final FqNameUnsafe longRange;
        @JvmField
        @NotNull
        public static final FqName deprecated;
        @JvmField
        @NotNull
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        @NotNull
        public static final FqName deprecationLevel;
        @JvmField
        @NotNull
        public static final FqName replaceWith;
        @JvmField
        @NotNull
        public static final FqName extensionFunctionType;
        @JvmField
        @NotNull
        public static final FqName parameterName;
        @JvmField
        @NotNull
        public static final FqName annotation;
        @JvmField
        @NotNull
        public static final FqName target;
        @JvmField
        @NotNull
        public static final FqName annotationTarget;
        @JvmField
        @NotNull
        public static final FqName annotationRetention;
        @JvmField
        @NotNull
        public static final FqName retention;
        @JvmField
        @NotNull
        public static final FqName repeatable;
        @JvmField
        @NotNull
        public static final FqName mustBeDocumented;
        @JvmField
        @NotNull
        public static final FqName unsafeVariance;
        @JvmField
        @NotNull
        public static final FqName publishedApi;
        @JvmField
        @NotNull
        public static final FqName iterator;
        @JvmField
        @NotNull
        public static final FqName iterable;
        @JvmField
        @NotNull
        public static final FqName collection;
        @JvmField
        @NotNull
        public static final FqName list;
        @JvmField
        @NotNull
        public static final FqName listIterator;
        @JvmField
        @NotNull
        public static final FqName set;
        @JvmField
        @NotNull
        public static final FqName map;
        @JvmField
        @NotNull
        public static final FqName mapEntry;
        @JvmField
        @NotNull
        public static final FqName mutableIterator;
        @JvmField
        @NotNull
        public static final FqName mutableIterable;
        @JvmField
        @NotNull
        public static final FqName mutableCollection;
        @JvmField
        @NotNull
        public static final FqName mutableList;
        @JvmField
        @NotNull
        public static final FqName mutableListIterator;
        @JvmField
        @NotNull
        public static final FqName mutableSet;
        @JvmField
        @NotNull
        public static final FqName mutableMap;
        @JvmField
        @NotNull
        public static final FqName mutableMapEntry;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kClass;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kCallable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        @NotNull
        public static final ClassId kProperty;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        @NotNull
        public static final FqName uByteFqName;
        @JvmField
        @NotNull
        public static final FqName uShortFqName;
        @JvmField
        @NotNull
        public static final FqName uIntFqName;
        @JvmField
        @NotNull
        public static final FqName uLongFqName;
        @JvmField
        @NotNull
        public static final ClassId uByte;
        @JvmField
        @NotNull
        public static final ClassId uShort;
        @JvmField
        @NotNull
        public static final ClassId uInt;
        @JvmField
        @NotNull
        public static final ClassId uLong;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;
        @NotNull
        public static final FqNames INSTANCE;

        private final FqNameUnsafe fqNameUnsafe(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = this.fqName(simpleName2).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqName(simpleName).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName fqName(String simpleName2) {
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "BUILT_INS_PACKAGE_FQ_NAM\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqName collectionsFqName(String simpleName2) {
            FqName fqName2 = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "COLLECTIONS_PACKAGE_FQ_N\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private final FqNameUnsafe rangesFqName(String simpleName2) {
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "RANGES_PACKAGE_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        @JvmStatic
        @NotNull
        public static final FqNameUnsafe reflect(@NotNull String simpleName2) {
            Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName2)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "KOTLIN_REFLECT_FQ_NAME.c\u2026r(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName annotationName(String simpleName2) {
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName2));
            Intrinsics.checkNotNullExpressionValue(fqName2, "ANNOTATION_PACKAGE_FQ_NA\u2026e.identifier(simpleName))");
            return fqName2;
        }

        private FqNames() {
        }

        static {
            Name name;
            PrimitiveType it;
            Collection collection;
            PrimitiveType item$iv;
            int n;
            FqNames fqNames;
            INSTANCE = fqNames = new FqNames();
            any = fqNames.fqNameUnsafe("Any");
            nothing = fqNames.fqNameUnsafe("Nothing");
            cloneable = fqNames.fqNameUnsafe("Cloneable");
            suppress = fqNames.fqName("Suppress");
            unit = fqNames.fqNameUnsafe("Unit");
            charSequence = fqNames.fqNameUnsafe("CharSequence");
            string = fqNames.fqNameUnsafe("String");
            array = fqNames.fqNameUnsafe("Array");
            _boolean = fqNames.fqNameUnsafe("Boolean");
            _char = fqNames.fqNameUnsafe("Char");
            _byte = fqNames.fqNameUnsafe("Byte");
            _short = fqNames.fqNameUnsafe("Short");
            _int = fqNames.fqNameUnsafe("Int");
            _long = fqNames.fqNameUnsafe("Long");
            _float = fqNames.fqNameUnsafe("Float");
            _double = fqNames.fqNameUnsafe("Double");
            number = fqNames.fqNameUnsafe("Number");
            _enum = fqNames.fqNameUnsafe("Enum");
            functionSupertype = fqNames.fqNameUnsafe("Function");
            throwable = fqNames.fqName("Throwable");
            comparable = fqNames.fqName("Comparable");
            intRange = fqNames.rangesFqName("IntRange");
            longRange = fqNames.rangesFqName("LongRange");
            deprecated = fqNames.fqName("Deprecated");
            deprecatedSinceKotlin = fqNames.fqName("DeprecatedSinceKotlin");
            deprecationLevel = fqNames.fqName("DeprecationLevel");
            replaceWith = fqNames.fqName("ReplaceWith");
            extensionFunctionType = fqNames.fqName("ExtensionFunctionType");
            parameterName = fqNames.fqName("ParameterName");
            annotation = fqNames.fqName("Annotation");
            target = fqNames.annotationName("Target");
            annotationTarget = fqNames.annotationName("AnnotationTarget");
            annotationRetention = fqNames.annotationName("AnnotationRetention");
            retention = fqNames.annotationName("Retention");
            repeatable = fqNames.annotationName("Repeatable");
            mustBeDocumented = fqNames.annotationName("MustBeDocumented");
            unsafeVariance = fqNames.fqName("UnsafeVariance");
            publishedApi = fqNames.fqName("PublishedApi");
            iterator = fqNames.collectionsFqName("Iterator");
            iterable = fqNames.collectionsFqName("Iterable");
            FqNames.collection = fqNames.collectionsFqName("Collection");
            list = fqNames.collectionsFqName("List");
            listIterator = fqNames.collectionsFqName("ListIterator");
            set = fqNames.collectionsFqName("Set");
            map = fqNames.collectionsFqName("Map");
            FqName fqName2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue(fqName2, "map.child(Name.identifier(\"Entry\"))");
            mapEntry = fqName2;
            mutableIterator = fqNames.collectionsFqName("MutableIterator");
            mutableIterable = fqNames.collectionsFqName("MutableIterable");
            mutableCollection = fqNames.collectionsFqName("MutableCollection");
            mutableList = fqNames.collectionsFqName("MutableList");
            mutableListIterator = fqNames.collectionsFqName("MutableListIterator");
            mutableSet = fqNames.collectionsFqName("MutableSet");
            mutableMap = fqNames.collectionsFqName("MutableMap");
            FqName fqName3 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue(fqName3, "mutableMap.child(Name.identifier(\"MutableEntry\"))");
            mutableMapEntry = fqName3;
            kClass = FqNames.reflect("KClass");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect("KProperty");
            kMutablePropertyFqName = FqNames.reflect("KMutableProperty");
            ClassId classId = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue(classId, "ClassId.topLevel(kPropertyFqName.toSafe())");
            kProperty = classId;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = fqNames.fqName("UByte");
            uShortFqName = fqNames.fqName("UShort");
            uIntFqName = fqNames.fqName("UInt");
            uLongFqName = fqNames.fqName("ULong");
            ClassId classId2 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue(classId2, "ClassId.topLevel(uByteFqName)");
            uByte = classId2;
            ClassId classId3 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue(classId3, "ClassId.topLevel(uShortFqName)");
            uShort = classId3;
            ClassId classId4 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue(classId4, "ClassId.topLevel(uIntFqName)");
            uInt = classId4;
            ClassId classId5 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue(classId5, "ClassId.topLevel(uLongFqName)");
            uLong = classId5;
            Cloneable cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            boolean bl = false;
            boolean bl2 = false;
            HashSet $this$apply = cloneable2;
            boolean bl3 = false;
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            boolean $i$f$mapTo = false;
            PrimitiveType[] primitiveTypeArray = $this$mapTo$iv;
            int n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                PrimitiveType primitiveType = item$iv = primitiveTypeArray[n];
                collection = $this$apply;
                boolean bl4 = false;
                name = it.getTypeName();
                collection.add(name);
            }
            primitiveTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl5 = false;
            $this$mapTo$iv = PrimitiveType.values();
            $i$f$mapTo = false;
            primitiveTypeArray = $this$mapTo$iv;
            n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                it = item$iv = primitiveTypeArray[n];
                collection = $this$apply;
                boolean bl6 = false;
                name = it.getArrayTypeName();
                collection.add(name);
            }
            primitiveArrayTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl7 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map2 = (Map)((Object)$this$apply);
                String string = primitiveType.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "primitiveType.typeName.asString()");
                map2.put(INSTANCE.fqNameUnsafe(string), primitiveType);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable2);
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            $this$apply = cloneable2;
            boolean bl8 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map3 = (Map)((Object)$this$apply);
                String string = primitiveType.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue(string, "primitiveType.arrayTypeName.asString()");
                map3.put(INSTANCE.fqNameUnsafe(string), primitiveType);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable2);
        }
    }
}

